USE [Goran]
GO

CREATE PROCEDURE [dbo].[TimesheetItem_FindTimesheetItems] (
	@PracovnikId	int = NULL,
	@ProjektManager	int = NULL,
	@GarantProjektu	int = NULL,
	@ObdobiOd		smalldatetime = NULL,
	@ObdobiDo		smalldatetime = NULL,
	@ProjektID		int = NULL,
	@FazeID			int = NULL,
	@KategorieID	int = NULL,
	@Text			nvarchar(100) = NULL,
	@Schvalene	bit = NULL,
	@VsechnyFaze	bit = NULL
) WITH RECOMPILE
AS
BEGIN
	SET NOCOUNT ON;
	SELECT TimesheetItemID
	FROM TimesheetItem
		LEFT JOIN Projekt ON (Projekt.ProjektID = TimesheetItem.ProjektID )
	WHERE (TimesheetItem.Deleted IS NULL)
		AND ((@PracovnikID IS NULL) OR (TimesheetItem.PracovnikID = @PracovnikID))
		AND ((@ProjektManager IS NULL) OR (Projekt.ProjectManagerEffectiveID = @ProjektManager))
		AND ((@GarantProjektu IS NULL) OR (Projekt.GarantProjektuEffectiveID = @GarantProjektu))
		AND ((@ObdobiOd IS NULL) OR (Datum >= @ObdobiOd))
		AND ((@ObdobiDo IS NULL) OR (Datum <= @ObdobiDo))
		AND ((@ProjektID IS NULL) OR (TimesheetItem.ProjektID = @ProjektID) OR (TimesheetItem.ProjektID IN (SELECT LowerProjektID FROM ProjektRelation WHERE HigherProjektID = @ProjektID)))
		--AND ((@FazeID IS NULL) OR (TimesheetItem.FazeID = @FazeID))
		AND ((@VsechnyFaze IS NUll) OR (@VsechnyFaze = 1) OR (TimesheetItem.FazeID = @FazeID) OR ((@FazeID IS NULL) AND (TimesheetItem.FazeID IS NULL)))
		AND ((@KategorieID IS NULL) OR (TimesheetItem.TimesheetItemCategoryID = @KategorieID))
		AND ((@Text IS NULL) OR (TimesheetItem.Text LIKE @Text))
		AND ((@Schvalene IS NULL) OR
			((@Schvalene = 1) OR (SchvalenoKdy IS NULL))
			AND ((@Schvalene = 0) OR (SchvalenoKdy IS NOT NULL))
			)
END
GO


EXEC TimesheetItem_FindTimesheetItems
	@ProjektID = 10,
	@ObdobiOd = '2008-01-01',
	@Schvalene = 1